import { BasicContainer } from '/sd:basic-container.js'; 
/**
 * class to create instance of Label. It save content text inside div container
 */
export class StandardLabel extends BasicContainer {
	/**
	 * Constructor
	* @param    {jQuery} xmlObject    	Data loaded from XML
	* @param    {String} parentId    	HTML ID of the object, which has to be a parent of constructing object
	* @param    {String} objClass    	Name of the CSS style's class
	* @param    {Integer} itemNumber    Number of object constructing item - if it is null, it means, that item is not numerable
	* @param    {String} objId    		ID of creating object - if itemNumber is not null, then itemNumber will be suffix of the ID
	* @param    {Boolean} standalone    It specifies if Container is simple (false) or referenced with object defined in XML file(true)
	 */
	constructor(xmlObject, parentId, objClass, itemNumber = null, objId = null, standalone = false) {
		super(xmlObject, parentId, objClass, itemNumber, objId, standalone);
		if(itemNumber == null)
			itemNumber = 0;
	}
	
	/**
	 * Gets value form HTML object related to instance of StandardLabel, and converts it to choose type
	 * @param {String} type		One of choose types: {"string", "float", "integer", "boolean"} 
	 * @returns {Object}		Returns value in choose type or null if indicated type is not supported
	 */
	getTextValue(type) {
		if(type == "string")
			return String(this.mainObj.innerHTML);
		else if(type == "float") 
			return parseFloat(this.mainObj.innerHTML);
		else if(type == "integer")
			return Math.round(this.mainObj.innerHTML);
		else if(type == "boolean")
			return this.mainObj.innerHTML;
		else
			return null;
	}
	
	/**
	 * Sets text to the HTML objcet related to instance of StandardLabel
	 * @param {String} value 	Text to set
	 */
	setTextValue(value) {
		this.mainObj.innerHTML = value;
	}
}